using System;
using System.Xml;
using System.Text;
using System.Collections;
using System.Collections.Generic;

/// <summary>
///    zarzdza list zda dotyczcych pienidzy,
///    ktre mog zosta odebrane przez klienta
/// </summary>
public class MoneyTalk
{
    public const string TalkRoot = "moneyTalk";
    public const string TalkNode = "talk";

    public string FileName { get; set; }

    private List<string> m_talkList = new List<string>();

    /// <summary>
    ///		zapisz dane XML do pliku
    /// </summary>
    public void WriteXML()
    {
        using (var xr = new XmlTextWriter(FileName, null))
        {
            xr.Formatting = Formatting.Indented;
            xr.Indentation = 4;

            xr.WriteStartDocument();
            xr.WriteComment("Przechowuje dane dla programu 'Rozmowy o pinidzach'.");

            xr.WriteStartElement("moneyTalk");

            xr.WriteElementString(TalkNode, "Zaoszczdzony grosz to za mao, zamie go na zotwk.");
            xr.WriteElementString(TalkNode, "Zachowaj swoje marne grosze. By moe bd kiedy co warte.");
            xr.WriteElementString(TalkNode, "To Twoje pienidze, ale lepiej na tym wyjdziesz, jeli zadzwonisz pod numer 10-10-XXX.");

            xr.WriteEndElement();

            xr.Flush();
        }
    }

    /// <summary>
    ///		odczytaj dane XML z pliku
    /// </summary>
    public void ReadXML()
    {
        using (var xr = new XmlTextReader(FileName))
        {
            string nodeName;

            while (xr.Read())
            {
                nodeName = xr.Name;

                if (nodeName == TalkNode)
                {
                    m_talkList.Add(xr.ReadString());
                }
            }
        }
    }

    /// <summary>
    ///		pobierz zdanie
    /// </summary>
    public string Talk
    {
        get
        {
            return m_talkList[
                new Random().Next(m_talkList.Count)];
        }
    }
}
